#pragma once
#include <saas/deploy_manager/scripts/cluster/cluster_task.h>

#include <saas/library/daemon_base/actions_engine/controller_client.h>
#include <saas/library/sharding/sharding.h>

#define RESHARD_ACTION_NAME "RESHARD"

namespace NDaemonController {

    class TReshardAction : public NRTYDeploy::TClusterAsyncAction {
    private:
        NSearchMapParser::TShardIndex ShardMin;
        NSearchMapParser::TShardIndex ShardMax;
        ui32 NewPartsCount;
        TString CType;
        TString Service;
        TString ServiceType;
    protected:

        virtual NJson::TJsonValue DoSerializeToJson() const;
        virtual void DoDeserializeFromJson(const NJson::TJsonValue& json);

        virtual TString GetCustomUriStart() const {
            return "reshard";
        }

        virtual TString DoBuildCommandStart() const {
            return
                "&shard_min=" + ToString(ShardMin) +
                "&shard_max=" + ToString(ShardMax) +
                "&new_parts_count=" + ToString(NewPartsCount) +
                "&ctype=" + CType +
                "&service=" + Service +
                "&service_type=" + ServiceType;
        }

        static TFactory::TRegistrator<TReshardAction> Registrator;
    public:

        TReshardAction() {}

        TReshardAction(NSearchMapParser::TShardIndex shardMin, NSearchMapParser::TShardIndex shardMax, NSearchMapParser::TShardIndex newPartsCount, const TString& ctype, const TString& service, const TString& serviceType)
            : TClusterAsyncAction(apStartAndWait)
            , ShardMin(shardMin)
            , ShardMax(shardMax)
            , NewPartsCount(newPartsCount)
            , CType(ctype)
            , Service(service)
            , ServiceType(serviceType)
        {}

        virtual TString ActionName() const { return RESHARD_ACTION_NAME; }
    };
}

