#include "script.h"
#include <saas/deploy_manager/server/client/client.h>
#include <saas/deploy_manager/scripts/common/scripts_helper.h>
#include "task.h"

namespace NRTYDeploy {

    TClusterTask::TPtr TScriptReshard::DoBuildTask(IDeployInfoRequest& request) const {
        const TCgiParameters& cgi = request.GetRD().CgiParam;

        TClusterTask::TCgiContext context = TClusterTask::TCgiContext::Parse(cgi);

        if (!context.Service) {
            request.Output() << "HTTP/1.1 400 \r\n\r\n";
            request.Output() << "service does not set";
            return nullptr;
        }

        if (!context.CType) {
            request.Output() << "HTTP/1.1 400 \r\n\r\n";
            request.Output() << "ctype does not set";
            return nullptr;
        }

        NSearchMapParser::TShardIndex shardMin = FromString(cgi.Get("shard_min"));
        NSearchMapParser::TShardIndex shardMax = FromString(cgi.Get("shard_max"));
        ui32 newPartsCount = FromString(cgi.Get("new_parts_count"));

        return new TReshardTask(shardMin, shardMax, newPartsCount, context, &request);
    }

    IScript::TFactory::TRegistrator<TScriptReshard> TScriptReshard::Registrator("reshard");
}

