#include "action.h"

#include <library/cpp/json/writer/json_value.h>
#include <library/cpp/json/json_reader.h>
#include <library/cpp/logger/global/global.h>
#include <util/stream/str.h>
#include <util/string/split.h>

namespace NRTYDeploy {

    NJson::TJsonValue TRestoreIndexAction::DoSerializeToJson() const {
        NJson::TJsonValue result;
        result.InsertValue("service", Service);
        result.InsertValue("ctype", CType);
        result.InsertValue("not_useful_slots", JoinStrings(NotUsefulSlots.cbegin(), NotUsefulSlots.cend(), ","));
        result.InsertValue("restore_slots", RestoreSlots);
        return result;
    }

    void TRestoreIndexAction::DoDeserializeFromJson(const NJson::TJsonValue& json) {
        NJson::TJsonValue::TMapType map;
        CHECK_WITH_LOG(json.GetMap(&map));
        Service = map["service"].GetStringRobust();
        CType = map["ctype"].GetStringRobust();
        RestoreSlots = map["restore_slots"].GetStringRobust();
        NotUsefulSlots.clear();
        StringSplitter(map["not_useful_slots"].GetStringRobust()).Split(',').AddTo(&NotUsefulSlots);
    }

    TRestoreIndexAction::TFactory::TRegistrator<TRestoreIndexAction> TRestoreIndexAction::Registrator(RESTORE_ACTION_NAME);
}
