#pragma once
#include <saas/deploy_manager/scripts/cluster/cluster_task.h>
#include <saas/deploy_manager/scripts/common/scripts_helper.h>
#include <saas/deploy_manager/scripts/common/script.h>
#include <saas/library/daemon_base/actions_engine/controller_script.h>
#include <saas/library/searchmap/searchmap.h>

#include <library/cpp/digest/md5/md5.h>

#include <util/system/hostname.h>
#include <util/thread/pool.h>

#define RESTORE_TASK_TYPE "RESTORE_INDEX_TASK"

namespace NRTYDeploy {

    class TRestoreIndexTask : public TClusterTask {
    private:
        NSearchMapParser::TSlotsPool RestoreSlots;
        TVector<TString> NotUsageSlots;

    public:
        TRestoreIndexTask(const NSearchMapParser::TSlotsPool& newSlots, const TVector<TString>& notUsageSlots,
            const TClusterTask::TCgiContext& context, NRTYDeploy::ICommonData* commonData);

        virtual void DoBuildTask() override;

    private:
        bool CheckTaskConstruction(NSearchMapParser::TSearchMap& ism, NSaas::TShardsDispatcher::TContext& sharding);
        NRTYScript::TSlotTaskContainer BuildIndexesClearing(const NRTYScript::TSlotTaskContainer& startNode);
    };
}
