#pragma once

#include <saas/library/daemon_base/actions_engine/controller_client.h>
#include <saas/util/tasks_graph/script.h>

#define SET_SLOT_INFO_ACTION_NAME "SET_SLOT_INFO"

namespace NDaemonController {

    class TSetSlotInfoAction : public TAction {
    private:
        TString Data;
        TString Searchmap;
        TString Slot;
        TString ServiceType;
        TString Service;
        TString CType;
        void FailOnAddPrev(const TString& s);
    protected:

        virtual NJson::TJsonValue DoSerializeToJson() const override;
        virtual void DoDeserializeFromJson(const NJson::TJsonValue& json) override;

        virtual TString DoBuildCommand() const override {
            return "command=set_slot_info";
        }

        virtual void DoInterpretResult(const TString& result) override;
        virtual void AddPrevActionsResult(const NRTYScript::ITasksInfo& info) override;

        static TFactory::TRegistrator<TSetSlotInfoAction> Registrator;
    public:

        TSetSlotInfoAction() {}

        TSetSlotInfoAction(const TString& searchmap, const TString& slot, const TString& service, const TString& serviceType, const TString& ctype)
            : Searchmap(searchmap)
            , Slot(slot)
            , ServiceType(serviceType)
            , Service(service)
            , CType(ctype)
        {}

        virtual bool GetPostContent(TString& result) const override {
            if (!Data)
                ythrow yexception() << "there is no data";
            result = Data;
            return true;
        }

        virtual TString ActionName() const override { return SET_SLOT_INFO_ACTION_NAME; }
    };
}
