#pragma once
#include <saas/deploy_manager/scripts/cluster/cluster_task.h>
#include <saas/library/searchmap/slots_pool.h>

namespace NRTYDeploy {

    class TModifySearchmapTask : public TClusterTask {
    private:
        NSearchMapParser::TSlotsPool Slots;
        TString Action;
        bool DeployProxies = true;
        float MayBeDeadIntervalPercentage = 0.01f;
        TMap<NSearchMapParser::TShardsInterval, NSearchMapParser::TShardsInterval> ReplaceIntervals;
    public:
        TModifySearchmapTask(const NSearchMapParser::TSlotsPool& slots, const TString& action, const TClusterTask::TCgiContext& context,
            NRTYDeploy::ICommonData* commonData, bool deployProxies = true, float mayBeDeadIntervalPercentage = 0.01f);
        void ReplaceInterval(const TString& from, const TString& to);
        virtual void DoBuildTask() override;
    };

}
