#pragma once
#include <saas/deploy_manager/scripts/common/script.h>
#include <saas/library/searchmap/searchmap.h>

namespace NRTYDeploy {
    class TScriptSecretKey: public IScript, public NSearchMapParser::ISearchMapScannerCallback {
    private:
        TString Service;
        TString DecodedMD5;
        TString ResultAdapterType;
        TString ResultService;
        TVector<TString> Secrets;
        TVector<TString> Adapters;
        NJson::TJsonValue Report;
        void BuildReportForName(const TString& serviceName);
    public:
        static TFactory::TRegistrator<TScriptSecretKey> Registrator;
        virtual bool Process(IDeployInfoRequest& request);
        virtual bool OnService(const NSearchMapParser::TSearchMapService& service);
        virtual void OnMetaService(const NSearchMapParser::TMetaService& info);

        virtual void OnHost(const NSearchMapParser::TSearchMapHost&, const NSearchMapParser::TSearchMapReplica&, const NSearchMapParser::TSearchMapService&) {

        }
    };
};

