#include <saas/deploy_manager/modules/services20/module.h>
#include <saas/deploy_manager/scripts/cluster/cluster_task.h>
#include <saas/deploy_manager/scripts/common/script.h>
#include <saas/deploy_manager/server/client/client.h>

namespace NRTYDeploy {

    class TScriptServices20DeployBinaries : public IScript {
    public:
        static TFactory::TRegistrator<TScriptServices20DeployBinaries> Registrator;
        bool Process(IDeployInfoRequest& request) override {
            const TCgiParameters& cgi = request.GetRD().CgiParam;
            const TString& service = cgi.Get("service");
            TString result;
            try {
                request.GetServices20Module().Deploy(service);
            } catch (...) {
                result += "On create service: " + CurrentExceptionMessage() + "\n";
            }
            ythrow yexception() << result;
            return true;
        }
    };

    static TScriptServices20DeployBinaries::TFactory::TRegistrator<TScriptServices20DeployBinaries> Registrator("service20_deploy");
};

