#include <saas/deploy_manager/modules/services20/module.h>
#include <saas/deploy_manager/scripts/common/script.h>
#include <saas/deploy_manager/server/client/client.h>

namespace NRTYDeploy {
    class TScriptServices20ReleaseSlots : public IScript {
    public:
        static TFactory::TRegistrator<TScriptServices20ReleaseSlots> Registrator;
        bool Process(IDeployInfoRequest& request) override {
            const TCgiParameters& cgi = request.GetRD().CgiParam;
            const TString& service = cgi.Get("service");
            TString result;
            request.GetServices20Module().RemoveAllocation(cgi.Get("id"), service);
            ythrow yexception() << result;
            return true;
        }
    };

    static TScriptServices20ReleaseSlots::TFactory::TRegistrator<TScriptServices20ReleaseSlots> Registrator("service20_release");
};
