#pragma once
#include <saas/library/daemon_base/actions_engine/controller_client.h>

#define SET_CONF_ACTION_NAME "SET_CONF"

namespace NDaemonController {
    class TSaveFileAction : public TAction {
    private:
        TString FileName;
        i64 Version = -1;

    protected:
        virtual NJson::TJsonValue DoSerializeToJson() const override;
        virtual void DoDeserializeFromJson(const NJson::TJsonValue& json) override;

        virtual TString GetCustomUri() const override {
            return "set_conf";
        }

        virtual TString DoBuildCommand() const override {
            return "root=/&service=/&filename=" + FileName;
        }

        virtual void DoInterpretResult(const TString& result) override;
    public:

        TSaveFileAction() {}

        virtual TDuration GetTimeoutDuration() const override {
            return TDuration::Seconds(10);
        }

        TSaveFileAction(const TString& fileName)
            : FileName(fileName)
        {}

    };

    class TSetConfAction : public TSaveFileAction {
    private:
        TString FileData;

    protected:
        virtual NJson::TJsonValue DoSerializeToJson() const override;
        virtual void DoDeserializeFromJson(const NJson::TJsonValue& json) override;

        static TFactory::TRegistrator<TSetConfAction> Registrator;
    public:
        TSetConfAction() {}
        TSetConfAction(const TString& fileName, const TString& fileData)
            : TSaveFileAction(fileName)
            , FileData(fileData)
        {}

        virtual bool GetPostContent(TString& result) const override {
            result = FileData;
            return true;
        }
        virtual TString ActionName() const override { return SET_CONF_ACTION_NAME; }
    };
}
