#include "save_current_config_action.h"
#include <library/cpp/logger/global/global.h>

namespace NRTYDeploy {

    NJson::TJsonValue TSaveCurrentConfigAction::DoSerializeToJson() const {
        NJson::TJsonValue result = TSaveFileAction::DoSerializeToJson();
        result.InsertValue("current_config", CurrentConfig.Serialize());
        return result;
    }

    void TSaveCurrentConfigAction::DoDeserializeFromJson(const NJson::TJsonValue& json) {
        TSaveFileAction::DoDeserializeFromJson(json);
        NJson::TJsonValue::TMapType map;
        CHECK_WITH_LOG(json.GetMap(&map));
        CurrentConfig.Deserialize(map["current_config"].GetStringRobust());
    }

    bool TSaveCurrentConfigAction::GetPostContent(TString& result) const {
        TNodesStructure conf;
        const TNodesStructure* curConf = &CurrentConfig;
        if (CurrentConfig.GetTimestamp() == TInstant::Zero()) {
            conf = CurrentConfig;
            conf.UpdateTimestamp();
            curConf = &conf;
        }
        result = curConf->Serialize();
        return true;
    }

    TSaveCurrentConfigAction::TFactory::TRegistrator<TSaveCurrentConfigAction> TSaveCurrentConfigAction::Registrator(SAVE_CURRENT_CONF_ACTION_NAME);
}
