#pragma once

#include "action.h"
#include <saas/deploy_manager/scripts/common/scripts_helper.h>

namespace NRTYDeploy {
    #define SAVE_CURRENT_CONF_ACTION_NAME "save_current_config"
    class TSaveCurrentConfigAction : public NDaemonController::TSaveFileAction {
    private:
        NRTYDeploy::TNodesStructure CurrentConfig;

    protected:
        virtual NJson::TJsonValue DoSerializeToJson() const;
        virtual void DoDeserializeFromJson(const NJson::TJsonValue& json);

        static TFactory::TRegistrator<TSaveCurrentConfigAction> Registrator;
    public:
        TSaveCurrentConfigAction() {}
        TSaveCurrentConfigAction(const TString& fileName, const NRTYDeploy::TNodesStructure& currentConfig)
            : TSaveFileAction(fileName)
            , CurrentConfig(currentConfig)
        {}
        virtual TString ActionName() const { return SAVE_CURRENT_CONF_ACTION_NAME; }
        virtual bool GetPostContent(TString& result) const;
    };
}
