#include "store_cluster_info.h"
#include <saas/deploy_manager/server/client/client.h>
#include <library/cpp/json/json_writer.h>

namespace NRTYDeploy {
    void TScriptStoreClusterInfo::DoPrepareJsonForReply(const TBroadcastSlotData& slot, NJson::TJsonValue& reply) {
        NJson::TJsonValue::TMapType map;
        const NJson::TJsonValue* info = reply.GetValueByPath("result", '.');
        if (info) {
            CommonData->GetStorage().SetValue(StorePath + "/" + slot.SMHost.GetSlotName(), NJson::WriteJson(info));
        } else {
            CommonData->GetStorage().SetValue(StorePath + "/" + slot.SMHost.GetSlotName(), NJson::WriteJson(&reply));
        }
    }

    bool TScriptStoreClusterInfo::Process(IDeployInfoRequest& request) {
        Command = "command=get_info_server";
        if (!request.GetRD().CgiParam.Has("store_path"))
            ythrow yexception() << "there is no store_path";
        StorePath = request.GetRD().CgiParam.Get("store_path");
        return TScriptBroadcast::Process(request);
    }

    IScript::TFactory::TRegistrator<TScriptStoreClusterInfo> TScriptStoreClusterInfo::Registrator("store_cluster_info");
}
