#include "set_user_access_config.h"
#include <saas/deploy_manager/server/client/client.h>

namespace NRTYDeploy {
    bool TScriptSetUserAccessConfig::Process(IDeployInfoRequest& request) {
        TString user = request.GetRD().CgiParam.Get("user");
        if (!user)
            throw yexception() << "user not set";
        const TBlob& data = request.GetBlob();
        request.GetUserAccessControl().SetUserConfig(TString(data.AsCharPtr(), data.Length()), user, false);
        request.Output() << "HTTP/1.1 200 Ok\r\n\r\n";
        return true;
    }

    TScriptSetUserAccessConfig::TFactory::TRegistrator<TScriptSetUserAccessConfig> TScriptSetUserAccessConfig::Registrator("set_user_access_config");
}
