#include "set_user_access_group_config.h"
#include <saas/deploy_manager/server/client/client.h>

namespace NRTYDeploy {
    bool TScriptSetUserAccessGroupConfig::Process(IDeployInfoRequest& request) {
        TString user = request.GetRD().CgiParam.Get("group");
        if (!user)
            throw yexception() << "user not set";
        const TBlob& data = request.GetBlob();
        request.GetUserAccessControl().SetUserConfig(TString(data.AsCharPtr(), data.Length()), user, true);
        request.Output() << "HTTP/1.1 200 Ok\r\n\r\n";
        return true;
    }
    TScriptSetUserAccessGroupConfig::TFactory::TRegistrator<TScriptSetUserAccessGroupConfig> TScriptSetUserAccessGroupConfig::Registrator("set_user_access_group_config");
}
