#pragma once


#include <saas/deploy_manager/storage/abstract.h>

#include <library/cpp/http/server/http_ex.h>

namespace NRTYDeploy {
    class IScript;
    class TCodedException : public yexception {
    public:
        TCodedException(int code)
            : Code(code)
        {}

        int GetCode() const {
            return Code;
        }

    private:
        int Code;
    };
}

class IDeployInfoRequest: public THttpClientRequestExtImpl<TServerRequestData>, public NRTYDeploy::ICommonData {
public:
    virtual ~IDeployInfoRequest() = default;

    virtual const TBlob& GetBlob() const = 0;
    virtual const TServerRequestData& GetRD() const = 0;
    virtual NRTYDeploy::IUserAccessControl& GetUserAccessControl() = 0;
    virtual NRTYDeploy::ICommonData& GetCommonData() const = 0;
};
