#include "server.h"

#include <saas/deploy_manager/scripts/common/file_content_generators/cached.h>
#include <saas/deploy_manager/meta/cluster.h>
#include <saas/library/daemon_base/daemon/controller.h>

DEFINE_CONTROLLER_COMMAND(THttpDeployManager, clear_caches, "")
    NSaas::TClusterLocker::ClearCaches();
    NRTYDeploy::TCachedFileContentGenerator::ClearCaches();
    Write("result", "success");
END_CONTROLLER_COMMAND

DEFINE_CONTROLLER_COMMAND(THttpDeployManager, invalidate_tags_info, "arguments: cache_ctype, cache_service_type, cache_service")
    TController::TGuardServer g = GetServer(false);
    if (g) {
        const TString& ctype = GetCgi().Get("cache_ctype");
        const TString& serviceType = GetCgi().Get("cache_service_type");
        const TString& service = GetCgi().Get("cache_service");
        bool reloadAfter = GetCgi().Has("reload_after") ? FromString<bool>(GetCgi().Get("reload_after")) : false;
        g->GetLogicServer().GetMeAs<THttpDeployManager>().GetResourcesManager().InvalidateCaches(ctype, serviceType, service, reloadAfter);
    }
    Write("result", "success");
END_CONTROLLER_COMMAND
