#pragma once

#include <saas/deploy_manager/storage/abstract.h>
#include <saas/deploy_manager/config/config.h>
#include <saas/deploy_manager/scripts/cluster/cluster_task.h>
#include <saas/util/external/mail_service.h>
#include <library/cpp/mediator/messenger.h>

#include <util/system/event.h>
#include <util/thread/pool.h>

namespace NRTYDeployServer {
    class TExecutor: public IObjectInQueue {
    private:
        NRTYDeploy::ICommonData* CommonData;
        TManualEvent& Active;
        const TDeployManagerConfig& Config;
    public:
        TExecutor(NRTYDeploy::ICommonData* commonData, TManualEvent& active, const TDeployManagerConfig& config)
            : Active(active)
            , Config(config)
        {
            CommonData = commonData;
        }

        void NotifyMessage(NRTYDeploy::TClusterTask::TPtr task, const TString& subject, bool notInfo);

        virtual void Process(void* ThreadSpecificResource) override;
    };

    class TExecutorRegular: public IObjectInQueue {
    private:
        NRTYDeploy::ICommonData* CommonData;
        TManualEvent& Active;
        const TDeployManagerConfig& Config;
    public:
        TExecutorRegular(NRTYDeploy::ICommonData* commonData, TManualEvent& active, const TDeployManagerConfig& config)
            : Active(active)
            , Config(config)
        {
            CommonData = commonData;
        }

        virtual void Process(void* /*ThreadSpecificResource*/) override;
    };

}
