#pragma once

#include <util/generic/noncopyable.h>
#include <util/thread/factory.h>
#include <util/system/guard.h>
#include <util/system/mutex.h>
#include <util/system/event.h>
#include <util/datetime/base.h>
#include <saas/deploy_manager/storage/abstract.h>

class THttpDeployManager;

namespace NRTYDeployServer {
    class TWatchDog: public IThreadFactory::IThreadAble, public TNonCopyable{
    public:
        TWatchDog(THttpDeployManager& owner);

        virtual ~TWatchDog() {
            TGuard<TMutex> g(Mutex);
            if (!!Thread)
                Thread->Join();
        }

        void Start();

        void Stop() {
            Stopped.Signal();
        }

    private:
        void DoExecute();

        inline TString GetMyName() const;

        void UnlockRestart();

        void LockRestart();

    private:
        THttpDeployManager& Owner;
        TSystemEvent Stopped;
        TAutoPtr<IThreadFactory::IThread> Thread;
        TMutex Mutex;
        static const TString LockName;
    };
}
