#pragma once

#include <saas/deploy_manager/server/client/client.h>
#include <saas/util/cluster/cluster.h>
#include <saas/util/queue.h>
#include <util/thread/pool.h>

#include <atomic>

namespace NRTYDeployServer {
    class TDatacentersPrefetch {
    private:
        NRTYCluster::TCluster::TMapType& ClustersPool;
        TRTYMtpQueue DCChecker;
        std::atomic<bool> IsActive;

    public:

        TDatacentersPrefetch(NRTYCluster::TCluster::TMapType& clustersPool)
            : ClustersPool(clustersPool)
        {
            IsActive.store(true);
        }

        virtual ~TDatacentersPrefetch() {
            CHECK_WITH_LOG(!IsActive.load());
        }

        void Stop() {
            IsActive.store(false);
            DCChecker.Stop();
        }

        virtual void ProcessImpl(TDeployInfoRequest& /*request*/) {

        }

        bool Start(NRTYDeploy::ICommonData* commonData);
    };

}
