#pragma once


#include <saas/deploy_manager/modules/golovan/module.h>
#include <saas/deploy_manager/modules/juggler/module.h>
#include <saas/deploy_manager/modules/nanny/nanny.h>
#include <saas/deploy_manager/modules/request_wizard_module.h>
#include <saas/deploy_manager/modules/resources/resources.h>
#include <saas/deploy_manager/modules/services20/module.h>
#include <saas/deploy_manager/modules/user_access_module.h>

#include <saas/deploy_manager/server/client/client.h>
#include <saas/deploy_manager/storage/abstract.h>

class TDeployInfoRequest: public IDeployInfoRequest {
private:
    NRTYDeploy::ICommonData* CommonData;
    THolder<NRTYDeploy::IUserAccessControl> AccessControl;
    const TDeployManagerConfig& Config;
    NRTYDeploy::TRequestContext RC;
    THolder<NRTYDeploy::IVersionedStorage> Storage;

public:
    TDeployInfoRequest(NRTYDeploy::ICommonData* commonData, const TDeployManagerConfig& config);

    bool Reply(void* /*ThreadSpecificResource*/) override;

    virtual NRTYDeploy::IControllersChecker& GetControllersChecker() override;

    virtual NRTYDeploy::IVersionedStorage& GetStorage() override;
    virtual const NRTYDeploy::IVersionedStorage& GetStorage() const override;

    virtual NRTYDeploy::IDistrTasksQueue& GetQueue() override;

    virtual const NRTYDeploy::TResourcesManager& GetResourcesManager() const override;

    virtual TNannyModule& GetNannyModule() const override;
    virtual TSDModule& GetSDModule() const override;
    virtual TJugglerModule& GetJugglerModule() const override;
    virtual TGolovanModule& GetGolovanModule() const override;
    virtual TRequestWizardModule& GetRequestWizardModule() override;
    virtual const TString& GetDeployManagerBalanserHost() const override;
    virtual ui16 GetDeployManagerBalanserPort() const override;
    virtual const TString& GetDeployManagerBalanserUriPrefix() const override;
    virtual TServices20Module& GetServices20Module() override;
    virtual NRTYDeploy::TCacheModule& GetCacheModule() override;
    virtual void SafeAddAndOwn(TAutoPtr<IObjectInQueue> obj) override;

    virtual const TBlob& GetBlob() const override final {
        return Buf;
    }

    virtual const TServerRequestData& GetRD() const override final {
        return RD;
    }

    virtual const TDeployManagerConfig& GetConfig() const override {
        return Config;
    }

    virtual NRTYDeploy::IUserAccessControl& GetUserAccessControl() override final {
        return *AccessControl;
    };

    virtual NRTYDeploy::ICommonData& GetCommonData() const override final {
        Y_VERIFY(CommonData, "Invalid common data");
        return *CommonData;
    }
};
