#pragma once

#include "inmem_slotchecker_storage.h"

#include <saas/deploy_manager/config/config.h>
#include <saas/deploy_manager/storage/abstract.h>
#include <util/generic/string.h>

namespace NRTYDeploy {

    class TControllersChecker: public IControllersChecker {
    private:
        IVersionedStorage& Storage;
        mutable TLocalSlotCheckerStorage LocalStorage;

    public:
        TControllersChecker(IVersionedStorage& storage, const TDeployManagerConfig::TCheckerConfig& config);

        virtual TSlotInfo CheckSlot(const NRTYCluster::TSlotData& sd) const override;
        virtual TSlotInfo UpdateSlot(const NRTYCluster::TSlotData& sd, const NJson::TJsonValue& serverStatusGlobal) const override;
        virtual TSlotInfo FailSlot(const NRTYCluster::TSlotData& sd) const override;
    };
}
