#pragma once

#include <saas/library/daemon_base/protos/status.pb.h>

#include <library/cpp/mediator/messenger.h>

#include <util/system/mutex.h>

#include <util/datetime/base.h>

#include <util/generic/hash.h>
#include <util/generic/list.h>
#include <util/generic/map.h>
#include <util/generic/ptr.h>

namespace NRTYDeploy {

    class TLocalSlotCheckerStorage : public TNonCopyable, IMessageProcessor {
    private:
        struct TLocalEntry {
            ui32 ExpirationTimeMinutes;
            TString Key;
            TList<TSimpleSharedPtr<TLocalEntry>>::const_iterator ExpirationListEntry;
            NController::TSlotChecker Value;
        };

        TMutex Mutex;
        using TKeyedStorage = THashMap<TString, TSimpleSharedPtr<TLocalEntry>>;
        mutable TKeyedStorage Storage;
        mutable TList<TSimpleSharedPtr<TLocalEntry>> ExpirationList;
        TDuration CacheTime;

    public:
        TLocalSlotCheckerStorage(const TDuration& cacheTime);
        virtual ~TLocalSlotCheckerStorage();

        ui32 GetSize() const;
        bool GetValue(const TString& key, NController::TSlotChecker& value) const;
        void SetValue(const TString& key, const NController::TSlotChecker& value);

    protected:
        // Testing entry
        virtual TInstant GetNow() const {
            return Now();
        }
        virtual bool Process(IMessage* message) override;
        virtual TString Name() const override;

    private:
        void CleanupStorageUnsafe() const;
    };

} // namespace NRTYDeploy
