
#include "inmem_slotchecker_storage.h"

#include <library/cpp/logger/global/global.h>
#include <library/cpp/testing/unittest/registar.h>

using namespace NRTYDeploy;
namespace {

    class TTestLocalSlotCheckerStorage : public TLocalSlotCheckerStorage {
    private:
        TDuration NowOffset;

    public:
        TTestLocalSlotCheckerStorage(const TDuration& cacheTime)
            : TLocalSlotCheckerStorage(cacheTime)
        {
        }

        void SetNowDelta(const TDuration& nowOffset) {
            NowOffset = nowOffset;
        }

    protected:
        TInstant GetNow() const override {
            return Now() + NowOffset;
        }
    };

} //namespace

Y_UNIT_TEST_SUITE(InmemSlotCheckerStorageTest) {

    Y_UNIT_TEST(SetGet) {
        TTestLocalSlotCheckerStorage storage(TDuration::Minutes(10));
        NController::TSlotChecker value;
        value.SetLastPing(100);
        value.SetLastReply(200);
        storage.SetValue("key", value);

        NController::TSlotChecker value2;
        UNIT_ASSERT(storage.GetValue("key", value2));
        UNIT_ASSERT_EQUAL(value2.GetLastPing(), value.GetLastPing());
        UNIT_ASSERT_EQUAL(value2.GetLastReply(), value.GetLastReply());
    };

    Y_UNIT_TEST(KeyExpires) {
        TTestLocalSlotCheckerStorage storage(TDuration::Minutes(10));
        NController::TSlotChecker value;
        value.SetLastPing(100);
        value.SetLastReply(200);
        storage.SetValue("key", value);

        storage.SetNowDelta(TDuration::Minutes(20));
        NController::TSlotChecker value2;
        UNIT_ASSERT(!storage.GetValue("key", value2));
    };

    Y_UNIT_TEST(SetKeyExtraLifetime) {
        TTestLocalSlotCheckerStorage storage(TDuration::Minutes(10));
        NController::TSlotChecker value;
        value.SetLastPing(100);
        value.SetLastReply(200);
        storage.SetValue("key", value);

        storage.SetNowDelta(TDuration::Minutes(5));
        value.SetLastPing(200);
        value.SetLastReply(200);
        storage.SetValue("key", value);

        storage.SetNowDelta(TDuration::Minutes(10));
        NController::TSlotChecker value2;
        UNIT_ASSERT(storage.GetValue("key", value2));
        UNIT_ASSERT_EQUAL(value2.GetLastPing(), value.GetLastPing());
        UNIT_ASSERT_EQUAL(value2.GetLastReply(), value.GetLastReply());

        storage.SetNowDelta(TDuration::Minutes(20));
        UNIT_ASSERT(!storage.GetValue("key", value2));
    };

}
