#include <library/cpp/logger/global/global.h>
#include <saas/deploy_manager/scripts/common/script.h>

#include "signals.h"


/////initiation/////

void TSaasDmUnistatSignals::BuildSignals() {
    TSaasDmUnistatSignals signals;
    DEBUG_LOG << "Init signals..." << Endl;
    signals.Init(TUnistat::Instance());
    DEBUG_LOG << "Init signals... ok" << Endl;
}

/////signals drilling/////

void TSaasDmUnistatSignals::Init(TUnistat &t) const {
    static const TVector<double> intervals = { 0, 2, 3, 5, 10, 15, 20, 25, 30,
        40, 50, 60, 70, 80, 90, 100, 125, 150, 175, 200, 225, 250, 300, 350, 400,
        500, 600, 700, 800, 900, 1000, 1500, 2000, 3000, 5000, 10000, 20000, 30000, 45000 };
    t.DrillHistogramHole("requests-all", "dhhh", Prio(), intervals);
    t.DrillHistogramHole("requests-CTYPE-all", "dhhh", Prio(), intervals);
    t.DrillHistogramHole("requests-CTYPE-ok", "dhhh", Prio(), intervals);

    t.DrillFloatHole("debug-errors", "dmmm", Prio(""));
    t.DrillFloatHole("debug-errors-CTYPE", "dmmm", Prio(""));

    TSet<TString> requestNames;
    Singleton<NRTYDeploy::IScript::TFactory>()->GetKeys(requestNames);
    for (const auto& command : requestNames) {
        t.DrillHistogramHole("requests-CTYPE-" + command, "dhhh", Prio(), intervals);
    }
}

/////pushing/////

void TSaasDmUnistatSignals::DoUnistatRecord(const TString& command, bool success, ui64 duration) {
    PushGlobalSignal("requests-all", duration);
    PushGlobalSignal("requests-CTYPE-all", duration);
    PushGlobalSignal("requests-CTYPE-" + command, duration);
    if (success) {
        PushGlobalSignal("requests-CTYPE-ok", duration);
    }
}
