// Copy-paste of https://a.yandex-team.ru/arc/trunk/arcadia/kernel/web_factors_info/factor_names.cpp?rev=7162609#L25
#include <saas/factor_slices/factors_gen.h>
#include <kernel/generated_factors_info/simple_factors_info.h>

#include "factors_info.h"

namespace NSaasFactors {
    class TFactorsInfo: public TSimpleSearchFactorsInfo<NSaasFactors::TFactorInfo> {
    public:
        TFactorsInfo(size_t begin, size_t end)
            : TSimpleSearchFactorsInfo<NSaasFactors::TFactorInfo>(end - begin, NSaasFactors::GetFactorsInfo() + begin)
        {
        }
    };

    class TGlobalSaasFactorsInfo : public TFactorsInfo {
    public:
        TGlobalSaasFactorsInfo()
            : TFactorsInfo(0, FI_FACTOR_COUNT)
        {
        }
    };

    inline const TFactorsInfo* GetSaasFactorsInfoImpl() {
        return Singleton<TGlobalSaasFactorsInfo>();
    }

    const IFactorsInfo* GetSaasFactorsInfo() {
        return GetSaasFactorsInfoImpl();
    }

    TAutoPtr<IFactorsInfo> GetFactorsInfoIf(size_t begin, size_t end) {
        Y_ASSERT(begin <= end);
        Y_ASSERT(end <= FI_FACTOR_COUNT);
        return new ::NSaasFactors::TFactorsInfo(begin, end);
    }
} // namespace NSaasFactors
