#include "common_adapter.h"

#include <saas/indexerproxy/adapters/proto_adapter/proto_adapter.h>
#include <saas/indexerproxy/context/action_reply.h>
#include <saas/indexerproxy/context/document.h>

#include <library/cpp/json/json_reader.h>
#include <library/cpp/json/json_writer.h>
#include <library/cpp/digest/md5/md5.h>

using namespace NIndexerProxy;
using namespace NJson;

// TAdapter

void TAdapter::ParseConfig(const TAdapterMinimalConfig& /*config*/) {
}

TAdapter::TAdapter(const TAdapterInitializationList& arguments) {
    ParseConfig(arguments.Config);
    arguments.ErrorMessage = "OK";
}

bool TAdapter::PreprocessMessage(ISenderTask& /*context*/) const {
    return true;
}

void TAdapter::ProcessMessage(ISenderTask& context) const {
    if(!(ParseMessage(context) && PreprocessMessage(context)) && (context.GetReply().GetHttpCode() == 200)) {
        context.GetReply().SetInfo(NRTYServer::TReply::dsINTERNAL_ERROR, "Incorrect message processing");
    }
}
