#pragma once

#include <library/cpp/json/json_value.h>
#include <util/string/vector.h>
#include <util/string/split.h>
#include <saas/indexerproxy/adapters/common/common_adapter.h>
#include <saas/indexerproxy/context/action_reply.h>

// TJsonAdapter
#define RETURN_ERROR(msg) {\
    context.GetReply().SetInfo(NRTYServer::TReply::dsUSER_ERROR, (TString)"parse error: " + (TString)msg);\
    return false;\
}

//#define __TEST_ONLY
namespace NIndexerProxy {
    class TJsonAdapter: public TAdapter {
    public:
        TJsonAdapter(const TAdapterInitializationList& arguments)
            : TAdapter(arguments)
        {

        }
    protected:
        mutable NJson::TJsonValue IncomingMessage;
        virtual bool ParseMessage(ISenderTask& context) const override;
    };
};
