#pragma once

#include <saas/indexerproxy/adapters/json_to_rty/json_to_rty_adapter.h>

#include <util/memory/blob.h>
#include <library/cpp/http/misc/httpreqdata.h>
#include <util/generic/string.h>

namespace NIndexerProxy {

    class TJsonWithRefsAdapter: public TJsonToRTYAdapter {
    public:
        static const TString AdapterAlias;
    public:
        TJsonWithRefsAdapter(const TAdapterInitializationList& arguments)
            : TJsonToRTYAdapter(arguments)
        {

        }

        const TString& GetFormatName() const override {
            return AdapterAlias;
        }
    protected:
        virtual bool ParseMessage(ISenderTask& context) const override;
    private:
        static TAdaptersFactory::TRegistrator<TJsonWithRefsAdapter> Registrator;
    };
};
