#include "json_to_rty_adapter.h"

#include <saas/indexerproxy/context/action_reply.h>
#include <saas/indexerproxy/context/document.h>

#include <library/cpp/logger/global/global.h>

const TString NIndexerProxy::TJsonToRTYAdapter::AdapterAlias("json_to_rty");

namespace NIndexerProxy {

    bool TJsonToRTYAdapter::PreprocessMessage(ISenderTask& context) const {
        if (!TJsonAdapter::PreprocessMessage(context))
            return false;
        try {
            auto dispatchableDocument = MakeHolder<TDispatchableDocument>(context);
            dispatchableDocument->GetAction().ParseFromJson(IncomingMessage);
            dispatchableDocument->GetAction().SetId(context.GetContext().GetRequestOptions().GetWaitReply() ? context.GetRequestId() : 0);

            context.GetContext().GetDocument().Reset(dispatchableDocument.Release());
            return true;
        } catch (const yexception& e) {
            RETURN_ERROR(e.what());
        }
    }
};

TAdaptersFactory::TRegistrator<NIndexerProxy::TJsonToRTYAdapter> NIndexerProxy::TJsonToRTYAdapter::Registrator(NIndexerProxy::TJsonToRTYAdapter::AdapterAlias);
