#pragma once

#include <saas/indexerproxy/adapters/common/common_adapter.h>
#include <saas/indexerproxy/adapters/adapters_factory.h>
#include <saas/library/behaviour/behaviour.h>

#include <library/cpp/json/json_reader.h>
#include <library/cpp/json/json_writer.h>

namespace NIndexerProxy {

    class TAdapterRTYServer: public TAdapter {
    public:
        static const TString AdapterAlias;
    public:
        virtual bool ParseMessage(ISenderTask& context) const override;
        TAdapterRTYServer(const TAdapterInitializationList& arguments)
            : TAdapter(arguments)
        {

        }

        virtual const TString& GetFormatName() const override {
            return AdapterAlias;
        }
    private:
        static ui64 GenerateMessageId();

        bool ParseMessage(ISenderTask& context, TString& body, TString& json) const;
        bool ReadAttributes(NRTYServer::TMessage& message, const TString& attributesType, const NJson::TJsonValue::TArray& array, TString& errorMessage) const;
        bool ReadMapElement(NRTYServer::TMessage& message, NJson::TJsonValue::TMapType::const_iterator& i, TString& errorMessage) const;
        bool ParseDocumentEntities(NRTYServer::TMessage& message, const NJson::TJsonValue& jSON, TString& errorMessage) const;
    private:
        static TAdaptersFactory::TRegistrator<TAdapterRTYServer> Registrator;
    };
}
