#pragma once

#include "interface_adapter.h"
#include <saas/indexerproxy/configs/config.h>
#include "adapters_factory.h"
#include <google/protobuf/message.h>
#include <util/network/socket.h>
#include <saas/library/socket_adapter/socket_adapter_zero_stream.h>
#include <saas/library/searchmap/searchmap.h>
#include <library/cpp/digest/md5/md5.h>
#include <util/folder/dirut.h>

class TAdapterHolder {
private:
    TSimpleSharedPtr<IAdapter> AdapterMessage;
    const TAdapterConfig& Config;
    time_t TimeModification;
public:

    void ProcessMessage(ISenderTask& context) const {
        AdapterMessage->ProcessMessage(context);
    }

    TAdapterHolder(const TAdapterConfig& config)
        : Config(config)
    {
        DEBUG_LOG << "Adapter " << Config.Name << " construction start..." << Endl;
        TimeModification = 0;

        TString errorMessage = "";
        TAdapterInitializationList list(Config, errorMessage);
        AdapterMessage = Singleton<TAdaptersFactory>()->Create(Config.Name, list);
        if(!AdapterMessage)
            errorMessage = "Adapter with name " + Config.Name + " is not registered";

        DEBUG_LOG << "Adapter " << Config.Name << " construction result: " << errorMessage << Endl;
        VERIFY_WITH_LOG(AdapterMessage, "Can't create adapter instance for %s -- %s", config.Name.data(), errorMessage.data());
        VERIFY_WITH_LOG(errorMessage == "OK", "Can't create adapter instance for %s. Initialization failed: %s", config.Name.data(), errorMessage.data());
    }

    ~TAdapterHolder() {
    }

};

