#pragma once

#include <util/string/vector.h>
#include <util/string/split.h>
#include <saas/indexerproxy/adapters/common/common_adapter.h>
#include <saas/indexerproxy/context/action_reply.h>
#include <saas/indexerproxy/adapters/adapters_factory.h>

//#define __TEST_ONLY
namespace NIndexerProxy {
    class TProtoAdapter: public TAdapter {
    public:
        static const TString AdapterAlias;
    public:
        TProtoAdapter(const TAdapterInitializationList& arguments)
            : TAdapter(arguments)
        {

        }
        virtual const TString& GetFormatName() const override {
            return TProtoAdapter::AdapterAlias;
        }
    protected:
        virtual bool ParseMessage(ISenderTask& context) const override;
    private:
        static TAdaptersFactory::TRegistrator<NIndexerProxy::TProtoAdapter> Registrator;
    };
};
