#pragma once

#include <saas/library/daemon_base/daemon/messages.h>

#include <library/cpp/json/json_value.h>

class TMessageCollectIndexerProxyInfo: public TCollectServerInfo {
private:
    TMap<TString, ui32> Tasks;

public:
    NJson::TJsonValue ExportReplies;
    NJson::TJsonValue QueuesInfo;

public:
    using TCollectServerInfo::TCollectServerInfo;

    TMap<TString, ui32>& GetTasks() {
        return Tasks;
    }

    NJson::TJsonValue GetTasksJson() const {
        NJson::TJsonValue result(NJson::JSON_MAP);
        for (TMap<TString, ui32>::const_iterator i = Tasks.begin(), e = Tasks.end(); i != e; ++i) {
            result.InsertValue(i->first, i->second);
        }
        return result;
    }

    virtual void Fill(TServerInfo& info) {
        TCollectServerInfo::Fill(info);
        info("tasks_count", GetTasksJson())
            ("export_replies", ExportReplies)
            ("queues", QueuesInfo);
    }
};
