#pragma once
#include "abstract_context.h"
#include "sender_context.h"
#include <saas/library/indexer_protocol/sender_neh.h>
#include <saas/library/behaviour/behaviour.h>
#include <saas/protos/rtyserver.pb.h>
#include <saas/indexerproxy/configs/config.h>

class TProxyConfig;
class TDispatchServiceSelector;

class TBackendsReplier: public TReplier {
private:
    class THandlerOnSend: public NRTYServer::IHandleListener {
    private:
        mutable ISrvDispContext* Replier;
        TDuration RecvTimeout;
    public:

        THandlerOnSend(ISrvDispContext* replier, const TProxyServiceConfig& config);

        // NRTYServer::IHandleListener
        virtual TDuration GetRecvTimeout() const;

        virtual void OnNotify(const NRTYServer::TQueryInfo& stat, NNeh::TResponseRef& ref) const;
        virtual void OnCancel(const NRTYServer::TQueryInfo& stat, const TString& reason) const;
        virtual void OnStart(const NRTYServer::TQueryInfo& stat) const;
    };
    THandlerOnSend Handler;
protected:
    virtual NRTYServer::TReply::TDispStatus DoGetDispStatus() const override;
    virtual bool DoSend(const TProxyConfig& config, TDispatchServiceSelector& selector) override;
    virtual bool DoVerify(const TProxyConfig& config, const TRTYMessageBehaviour& bh) const override;
    virtual void DoFinish() override;
    virtual bool DoStoreStatus(const TString& backend, const TString& status) override;
public:
    TBackendsReplier(const TString& serviceName, ISenderTask& task, const NRTYServer::TMessage& message, const TDispatcherConfig* config, TDeferredMessagesQueue& storage);
};
