#pragma once
#include "abstract_context.h"
#include "sender_context.h"
#include <saas/library/indexer_protocol/sender_neh.h>
#include <saas/library/behaviour/behaviour.h>
#include <saas/protos/rtyserver.pb.h>

class TProxyConfig;
class TDispatchServiceSelector;

class TDistributorReplier: public TReplier {
private:
    class THandlerOnSend: public NRealTime::TDepositDistributorClient::IHandler {
    private:
        mutable ISrvDispContext* Replier;
        const TDispatcherConfig* Config;

    public:
        THandlerOnSend(ISrvDispContext* replier, const TDispatcherConfig* config);

        // TDepositDistributorClient::IHandler
        virtual void OnBeforeSending(const TVector<NBus::TNetAddr>& addrs) const;
        virtual void OnReply(const NBus::TNetAddr& addr, const NRealTime::TIndexedDocDepSlip::EStatus status, const TString& message = TString()) const;
        virtual void OnError(const NBus::TNetAddr& addr, const TString& error) const;
    };

    const THandlerOnSend Handler;

protected:
    virtual NRTYServer::TReply::TDispStatus DoGetDispStatus() const override;
    virtual bool DoSend(const TProxyConfig& config, TDispatchServiceSelector& selector) override;
    virtual bool DoVerify(const TProxyConfig& config, const TRTYMessageBehaviour& bh) const override;
    virtual void DoFinish() override;
    virtual bool DoStoreStatus(const TString& backend, const TString& status) override;

public:
    TDistributorReplier(const TString& serviceName, ISenderTask& task, const NRTYServer::TMessage& message, const TDispatcherConfig* config, TDeferredMessagesQueue& storage);
};

