#include "sender_context.h"

#include <saas/library/behaviour/behaviour.h>
#include <saas/indexerproxy/server/client.h>
#include <saas/indexerproxy/configs/dispatch_config.h>
#include <saas/library/searchmap/searchmap.h>

TReplier::TReplier(const TString& serviceName, ISenderTask& task, const NRTYServer::TMessage& message, const TDispatcherConfig* config, TDeferredMessagesQueue& storage)
    : ISrvDispContext(serviceName, task, message, config)
    , Storage(storage)
{
    IsAsync = IsAsyncMessage(Message);
}

void TReplier::StoreInQueue(const TString& queueName, const NRTYServer::TMessage& message) {
    if (!Storage.GetConfig().GetOwner().GetServicesConfig().GetConfig(GetServiceName()).DeferredQueueEnabled) {
        StoreStatus(queueName, "Queue disabled for service");
    } else if (GetContext().GetContext().GetRequestOptions().QueueDisabled()) {
        StoreStatus(queueName, "Queue disabled for request");
    } else {
        try {
            Storage.Store(queueName, message, Storage.GetConfig().GetDeferredMQConfig().AsyncMode);
            StoreStatus(queueName, "");
        } catch (...) {
            StoreStatus(queueName, CurrentExceptionMessage());
        }
    }
}
