#pragma once

#include <library/cpp/logger/global/global.h>
#include <saas/library/behaviour/behaviour.h>
#include <saas/indexerproxy/adapters/interface_adapter.h>
#include <saas/indexerproxy/dispatching/send_status.h>

#include <yweb/realtime/distributor/client/distclient.h>

#include <library/cpp/json/json_value.h>
#include <library/cpp/json/json_writer.h>

#include <util/generic/maybe.h>

#include "abstract_context.h"

class TLog;
class TDeferredMessagesQueue;
class TDispatcherConfig;

class TReplier: public ISrvDispContext {
protected:
    TDeferredMessagesQueue& Storage;
    bool IsAsync;

public:
    TReplier(const TString& serviceName, ISenderTask& task, const NRTYServer::TMessage& message, const TDispatcherConfig* config, TDeferredMessagesQueue& storage);
    void StoreInQueue(const TString& queueName, const NRTYServer::TMessage& message);

    virtual NJson::TJsonValue GetReply() const override {
        NJson::TJsonValue message;
        for (TSendStatusData::const_iterator i = Status.begin(), e = Status.end(); i != e; ++i) {
            message.InsertValue(i->first, i->second->GetMessage());
        }
        if (ReplyOverride.Defined()) {
            message.InsertValue("additional", ReplyOverride.GetReply());
        }
        message.InsertValue("disp_status", (ui32)GetDispStatus());
        return message;
    }
};
