#pragma once
#include "abstract_context.h"
#include "sender_context.h"
#include <saas/library/indexer_protocol/sender_neh.h>
#include <saas/library/behaviour/behaviour.h>
#include <saas/protos/rtyserver.pb.h>

class TProxyConfig;
class TDispatchServiceSelector;

class TVoidReplier: public TReplier {
protected:
    virtual bool DoVerify(const TProxyConfig& /*config*/, const TRTYMessageBehaviour& /*bh*/) const override {
        return true;
    }

    virtual void DoFinish() override {
        FAIL_LOG("Incorrect usage case");
    }

    virtual NRTYServer::TReply::TDispStatus DoGetDispStatus() const override {
        FAIL_LOG("Incorrect usage case");
        return NRTYServer::TReply::dsINTERNAL_ERROR;
    }

    virtual bool DoSend(const TProxyConfig& config, TDispatchServiceSelector& selector) override;

    virtual bool DoStoreStatus(const TString& /*backend*/, const TString& /*status*/) override {
        CHECK_WITH_LOG("Incorrect usage case");
        return true;
    }

public:
    TVoidReplier(const TString& serviceName, ISenderTask& task, const NRTYServer::TMessage& message, const TDispatcherConfig* config, TDeferredMessagesQueue& storage);
};
