#pragma once

#include "distributor.h"
#include "routeslist.h"
#include "send.h"

#include <saas/library/indexer_protocol/sender_neh.h>
#include <saas/indexerproxy/context/sender_context.h>
#include <saas/indexerproxy/context/persqueue_context.h>
#include <saas/indexerproxy/configs/config.h>
#include <saas/indexerproxy/common/messages.h>
#include <library/cpp/logger/global/global.h>
#include <library/cpp/mediator/messenger.h>

#include <util/generic/ptr.h>
#include <util/thread/pool.h>

class TDispatcher;

class TDispatchServiceSelector: public IMessageProcessor {
private:
    TDispatcher& Dispatcher;
    const TDispatcherConfig& Config;
    TMutex Mutex;
    TDistributorRequester Distributors;
    TRTYMultiRequester Requester;
    TPersQueueManager PersQueueManager;
public:
    TDispatchServiceSelector(TDispatcher& dispatcher);
    ~TDispatchServiceSelector();

    TRTYMultiRequester& GetRequester() {
        return Requester;
    }

    TDispatcher& GetDispatcher() {
        return Dispatcher;
    }

    TDistributorRequester& GetDistributors() {
        return Distributors;
    }

    TPersQueueManager& GetPersQueueManager() {
        return PersQueueManager;
    }

    virtual bool Process(IMessage* message);
    virtual TString Name() const {
        return "ServicesSelector";
    }

    void AddDispatchTask(ISrvDispContext& message);
    void Stop() {
        TGuard<TMutex> g(Mutex);
        Requester.Stop();
    }
};
