#pragma once

#include "dispatch_queue.h"
#include "deferred_messages_queue.h"

#include <saas/indexerproxy/configs/config.h>
#include <library/cpp/logger/global/global.h>
#include <saas/library/indexer_protocol/sender_neh.h>

#include <library/cpp/neh/http2.h>

class TDispatcher {
private:
    const TDispatcherConfig& Config;
    TDeferredMessagesQueue& Storage;
    TDispatchServiceSelector DispatchQueue;
public:
    TDispatcher(const TDispatcherConfig& config, TDeferredMessagesQueue& storage)
        : Config(config)
        , Storage(storage)
        , DispatchQueue(*this)
    {
    }

    TDispatchServiceSelector& GetSelector() {
        return DispatchQueue;
    }

    const TDispatcherConfig& GetConfig() const {
        return Config;
    }

    TLog& GetLog() {
        return Config.GetLog();
    }

    TDeferredMessagesQueue& GetStorage() {
        return Storage;
    }

    void Stop() {
        INFO_LOG << "Closing DispatchQueueRabbit..." << Endl;
        Storage.Stop();
        INFO_LOG << "Closing DispatchQueueRabbit...OK" << Endl;
        INFO_LOG << "Closing DispatchQueue..." << Endl;
        DispatchQueue.Stop();
        INFO_LOG << "Closing DispatchQueue...OK" << Endl;
    }

};
