#pragma once

#include <saas/indexerproxy/configs/config.h>

#include <yweb/realtime/distributor/client/distclient.h>

#include <util/generic/map.h>
#include <util/generic/ptr.h>

namespace NRTYServer {
    class TMessage;
}

class TDispatcherConfig;

class TDistributorRequester {
private:
    using TClient = TSimpleSharedPtr<NRealTime::TDepositDistributorClient>;
    using TClients = TMap<TString, TClient>;

private:
    const TDispatcherConfig& Config;
    TMap<TString, TAtomicSharedPtr<NBus::TBusSessionConfig>> BusSessionConfigs;
    TClients Clients;

public:
    TDistributorRequester(const TDispatcherConfig& config);

    void Send(const TString& service, const NRTYServer::TMessage& message, const NRealTime::TDepositDistributorClient::IHandler* handler);

private:
    NRealTime::TDistributors Preresolve(const NRealTime::TDistributors& original);
};
