#include "deferred_messages_queue.h"

class TFakeMessageQueue : public TDeferredMessagesQueue::IQueue {
public:
    TFakeMessageQueue(const TDispatcherConfig& /*config*/, const TString& /*name*/, const TDeferredMessagesQueue::TQueueHeader& header)
        : Header(header)
    {}

    IMessage::TPtr Get() override {
        return nullptr;
    }

    TDeferredMessagesQueue::TQueueHeader GetHeader() const override {
        return Header;
    }

    bool CheckMessageForStore(const NRTYServer::TMessage& /*message*/, TString& reply) const override {
        reply = "MQ is disabled";
        return false;
    }

    void Store(const NRTYServer::TMessage& /*data*/) override {
        return;
    }

    void Purge() override {
    }

    void CollectGarbage() override {
    }

    ui32 Size() const override {
        return 0;
    }

    void Stop() override {
    }

    ui64 SizeInBytes() const override {
        return 0;
    }

private:
    const TDeferredMessagesQueue::TQueueHeader Header;

    static TFactory::TRegistrator<TFakeMessageQueue> Registrator;
};

TFakeMessageQueue::TFactory::TRegistrator<TFakeMessageQueue> TFakeMessageQueue::Registrator(TDeferredMQConfig::DISABLED);
