#include "send.h"

#include <saas/protos/rtyserver.pb.h>

#include <library/cpp/neh/neh.h>
#include <library/cpp/neh/rpc.h>

TRTYMultiRequester::TRTYMultiRequester(ui32 attemptsCount, NNeh::IProtocol* protocol)
    : Requester(attemptsCount, protocol)
{
}

ui32 TRTYMultiRequester::QueueSize() const {
    return Requester.QueueSize();
}

void TRTYMultiRequester::Start(ui32 threadsNum) {
    Requester.Start(threadsNum);
}

void TRTYMultiRequester::Stop() {
    Requester.Stop();
}

void TRTYMultiRequester::Send(const TString& host, ui16 port, const NRTYServer::TMessage& message, const NRTYServer::IHandleListener* handleCallback, const TString& serviceInfo) {
    NNeh::TDataSaver nehData;
    message.SerializeToArcadiaStream(&nehData);
    NNeh::TMessage nehMessage(serviceInfo, TString(&nehData[0], nehData.size()));
    Requester.Send(host, port, nehMessage, handleCallback);
}
