#pragma once

#include <yweb/robot/kiwi/base/defs.h>

#include <util/generic/string.h>

namespace NSaas {
    struct TKiwiExportConfig {
    public:
        TString TupleParsingOptions;
        TString User = "any";
        TString LogFile;
        ui32 Threads = 1;
        ui32 ResendAttempts = 3;
        ui16 Port = NKiwi::NDefs::SubscriberMsgBusPort;
        bool Enabled = false;
        bool VerboseLogging = false;

        // ybus settings
        ui32 MaxInFlight = 50;
        ui32 MaxInBytes = 1024 * 1024 * 1024;
        ui32 MaxTimeout = 200;
    };
}
