#pragma once

#include <saas/library/daemon_base/metrics/servicemetrics.h>

#include <library/cpp/object_factory/object_factory.h>

#include <util/generic/string.h>
#include <util/generic/ptr.h>
#include <util/generic/vector.h>
#include <util/memory/blob.h>

namespace NKwExport {
    class TExportRecord;
}

namespace NSaas {
    class TExportTypeOptions;

    enum class EAckMode {
        Default,
        Inverse,
        Always
    };

    struct TIncomingDocumentCtx {
        const NKwExport::TExportRecord& ExportRecord;
        TString Service;
        TString Adapter;
        TServiceMetricPtr Metric;
        TBlob Data;
        EAckMode AckMode;

        TIncomingDocumentCtx(const NKwExport::TExportRecord& record)
            : ExportRecord(record)
            , Metric(nullptr)
            , AckMode(EAckMode::Default)
        {}
    };
    using TIncomingDocumentCtxPack = TVector<TIncomingDocumentCtx>;

    class IExportProcessor {
    public:
        virtual ~IExportProcessor() {}
        virtual TIncomingDocumentCtxPack Process(const NKwExport::TExportRecord& record) const = 0;
    };

    class TCommonExportProcessor: public IExportProcessor {
    protected:
        const EAckMode AckMode;

    public:
        TCommonExportProcessor(const NSaas::TExportTypeOptions& exportType);

        TIncomingDocumentCtx CreateContext(const NKwExport::TExportRecord& record) const;
    };

    using TExportProcessorFactory = NObjectFactory::TParametrizedObjectFactory<IExportProcessor, TString, const NSaas::TExportTypeOptions&>;

    TAutoPtr<IExportProcessor> CreateExportProcessor(const NSaas::TExportTypeOptions& exportType);
    TAutoPtr<IExportProcessor> CreateDefaultExportProcessor();
}
