#include <library/cpp/testing/unittest/registar.h>

#include "tskv_helpers.h"

Y_UNIT_TEST_SUITE(TIproxyLoggingHelpersTest) {
    inline TString Convert(const TStringBuf& vl) {
        NUtil::TTSKVRecord res;
        TskvConvertKiwiLegacy(res, vl);
        return res.ToString();
    }

    Y_UNIT_TEST(TestKwSysLog) {
        UNIT_ASSERT_VALUES_EQUAL("tskv", Convert(""));
        UNIT_ASSERT_VALUES_EQUAL("tskv\texpl=aaa bbb ccc", Convert("aaa bbb ccc"));

        UNIT_ASSERT_VALUES_EQUAL("tskv\tkey=URL\texpl=error error_detail", Convert("error key# URL expl# error_detail"));
        UNIT_ASSERT_VALUES_EQUAL("tskv\tkey=URL\texpl=error error_detail", Convert("error    key#     URL expl#   error_detail"));
        UNIT_ASSERT_VALUES_EQUAL("tskv\ta=\tb=23\tc=\td=", Convert("a# b# 23 c# d#"));
        UNIT_ASSERT_VALUES_EQUAL("tskv\ta=\tb=23\tc=\td=5", Convert("a# b# 23 c# d# 5"));

        UNIT_ASSERT_VALUES_EQUAL("tskv", Convert("#"));
        UNIT_ASSERT_VALUES_EQUAL("tskv", Convert("# "));
        UNIT_ASSERT_VALUES_EQUAL("tskv", Convert("##"));
        UNIT_ASSERT_VALUES_EQUAL("tskv", Convert("## "));
        UNIT_ASSERT_VALUES_EQUAL("tskv\tk=", Convert("k#"));
        UNIT_ASSERT_VALUES_EQUAL("tskv\tk=", Convert("# k#"));
        UNIT_ASSERT_VALUES_EQUAL("tskv\tk=", Convert("#k#"));
        UNIT_ASSERT_VALUES_EQUAL("tskv\tk=\texpl=1", Convert("k####1"));
    }
}
