#pragma once

#include "common_task.h"
#include "indexer_proxy_specific.h"
#include "request_opts.h"

#include <saas/indexerproxy/adapters/interface_adapter.h>
#include <saas/indexerproxy/configs/config.h>
#include <saas/indexerproxy/context/action_reply.h>
#include <saas/indexerproxy/context/abstract_context.h>
#include <saas/indexerproxy/context/document.h>
#include <saas/library/daemon_base/metrics/servicemetrics.h>

#include <library/cpp/http/misc/httpcodes.h>
#include <saas/library/authorization/auth.h>

#include <saas/util/queue.h>
#include <saas/util/destroyer.h>

#include <library/cpp/string_utils/quote/quote.h>

class TAsyncSenderTask: public TCommonSenderTask {
private:
    NDispatchableDocument::TTrace Trace;

public:
    TAsyncSenderTask(TTaskExecutor& executor, TFinishExecutor& finishExecutor, IAdapterContext* context, TStaticServiceMetrics& metrics, ISenderTask::TDestroyer& destroyer);

    virtual bool BackendAllowed(const TString& backend) const override {
        if (!TCommonSenderTask::BackendAllowed(backend))
            return false;

        CHECK_WITH_LOG(!!Context->GetDocument());
        CHECK_WITH_LOG(IsAsyncMessage(Context->GetDocument()->GetMessage()));

        const NDispatchableDocument::TBackendTrace* trace = nullptr;
        if (Trace.GetTrace(backend, &trace))
            return !trace->GetIsFinished();

        return true;
    }

    virtual const NDispatchableDocument::TTrace* GetTrace() const override {
        return &Trace;
    }

    virtual int DoFillDocuments(TAdaptersManager& processor) override;
};
