#pragma once
#include <saas/library/authorization/auth.h>
#include <saas/library/socket_adapter/socket_adapter_zero_stream.h>
#include <saas/library/searchmap/searchmap.h>
#include <saas/indexerproxy/adapters/plugin_adapter.h>

class TProxyConfig;
class TDispatcher;
class ISenderTask;

class TAdaptersManager {
private:
    const TProxyConfig& Config;
    TProxyWatchdogSubsciber& WatchdogSubsciber;
    TMap<TString, TSimpleSharedPtr<TAdapterHolder>> AdapterByName;
    TDispatcher& Dispatcher;
    NSaas::TAuthorization& Authorizer;
public:
    TAdaptersManager(const TProxyConfig& config, TProxyWatchdogSubsciber& wdSub, TDispatcher& dispatcher, NSaas::TAuthorization& authorizer);
    int FillDocuments(ISenderTask& context) const;
    bool IsAcceptableByFilter(ISenderTask &context) const;
    bool Authorize(ISenderTask& context) const;
    bool ShouldDump(const TString& service) const;
    TString DecodeServiceName(const TString& serviceNameHash) const;
    TDispatcher& GetDispatcher() { return Dispatcher; }
};
