#include "sender_executor.h"
#include "sender_task.h"
#include "async_sender_task.h"
#include <saas/indexerproxy/logging/rty_ipr.h>
#include <saas/util/logging/tskv_log.h>

void TTaskExecutor::AddContext(IAdapterContext* context) {
    CHECK_WITH_LOG(!!context);
    THolder<TCommonSenderTask> st;

    if (context->GetRequestOptions().IsTrace()) {
        st.Reset(new TAsyncSenderTask(*this, FinishExecutor, context, Metrics, Destroyer));
    } else {
        st.Reset(new TSenderTask(*this, FinishExecutor, context, Metrics, Destroyer));
    }

    if (!TOptionalRTYMtpQueue::Add(st.Get())) {
        NUtil::TTSKVRecord tskv("saas-ipr-log");
        tskv.AddIsoEventTime().ForceAdd("ip", context->GetRemoteAddr()).ForceAdd("url", context->GetScriptName())
                .ForceAdd("query", context->GetQueryString()).ForceAdd("size", context->GetPost().Length())
                .Add("status", "limit_on_queue").Add("kind", "ip-queue").Add("duration", (Now() - context->GetReceiveTime()).MilliSeconds());

        IPR_LOG << tskv.ToString() << Endl;
        DEBUG_LOG << tskv.Add("client_id", st->GetRequestId()).ToString()  << Endl;
        context->Reply(500, "", "can't add into queue");
    } else {
        Y_UNUSED(st.Release());
    }
}
